/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWArrayHandler;
import filenet.vw.api.VWCompoundStepDefinition;
import filenet.vw.api.VWException;
import filenet.vw.api.VWIdGenerator;
import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.api.VWXMLHandler;
import filenet.vw.base.VWString;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;
import org.xml.sax.SAXParseException;

public final class VWStepPaletteDefinition
implements Serializable {
    private static final long serialVersionUID = 471L;
    private static final int INVALID_STEP_ID = -1;
    private static final int FIRST_STEP_ID = 1;
    private static final String PASTE_STEP_PALETTE_NAME = "###FN_INTERNAL_SPECIAL_TEMP_PASTE_STEP_PALETTE###";
    private String m_name = null;
    private String m_description = null;
    private VWMapNode[] m_mapNodes = null;
    private VWArrayHandler m_mapNodesHandler = null;
    private VWIdGenerator m_mapNodeIdGenerator = new VWIdGenerator(1, 1);

    public static String _get_FILE_DATE() {
        return "$Date: 2010-06-08 22:22:29 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Kevin Bentley;096657649;kbentley@us.ibm.com (kbentley) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_460_Int/4 $";
    }

    public VWStepPaletteDefinition() throws VWException {
        try {
            Class<?> mapNodeClass = Class.forName("filenet.vw.api.VWMapNode");
            this.m_mapNodesHandler = new VWArrayHandler(mapNodeClass);
        }
        catch (Exception ex) {
            throw new VWException("vw.api.VWStepPaletteDefinitionErrorInArrayHandler", "exception initializing the array handler, {0}", ex.toString());
        }
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String theName) {
        this.m_name = theName;
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String theDescription) {
        this.m_description = theDescription;
    }

    public VWStepDefinition createStep(String theStepName) throws VWException {
        VWStepDefinition newStep = new VWStepDefinition(this.m_mapNodeIdGenerator.getNextId());
        newStep.setName(theStepName);
        this.m_mapNodes = (VWMapNode[])this.m_mapNodesHandler.addElementToArray(this.m_mapNodes, newStep);
        return newStep;
    }

    public VWCompoundStepDefinition createCompoundStep(String theStepName) throws VWException {
        VWCompoundStepDefinition newCompStep = new VWCompoundStepDefinition(this.m_mapNodeIdGenerator.getNextId());
        newCompStep.setName(theStepName);
        this.m_mapNodes = (VWMapNode[])this.m_mapNodesHandler.addElementToArray(this.m_mapNodes, newCompStep);
        return newCompStep;
    }

    public VWMapNode[] pasteSteps(String xmlStepdefs) throws VWException {
        VWMapNode[] newMapNodes = null;
        String stepPastePre = "<?xml version='1.0' encoding='UTF-8'?>\n<!DOCTYPE StepPaletteDefinition SYSTEM \"spdef4.dtd\">\n<StepPaletteDefinition ApiVersion=\"4.0\"\nOrigin=\"JavaAPI\"\n Name=\"###FN_INTERNAL_SPECIAL_TEMP_PASTE_STEP_PALETTE###\" Description=\"Temporary step palette created internally during pasteSteps operation\" >";
        String stepPastePost = "</StepPaletteDefinition>\n";
        String theXML = stepPastePre + xmlStepdefs + stepPastePost;
        try {
            VWStepPaletteDefinition tempStepPaletteDef = null;
            try {
                tempStepPaletteDef = VWXMLHandler.parseXMLStepPalette(new BufferedReader(new StringReader(theXML)), true);
            }
            catch (SAXParseException err) {
                VWString parsingError = new VWString("vw.api.ParsingError", "** Parsing error");
                VWString line = new VWString("vw.api.Line", "line");
                String errString = parsingError + ", " + line + " " + err.getLineNumber() + ", uri <" + err.getSystemId() + ">\n" + "   " + err.getMessage();
                throw new VWException("vw.api.VWStepPaletteDefinitionXMLParseError", "XML Parsing error {0}.", errString);
            }
            catch (Exception ex2) {
                throw new VWException("vw.api.VWStepPaletteDefinitionXMLReadError", " Exception reading XML, {0}.", ex2.getMessage());
            }
            if (tempStepPaletteDef != null && (newMapNodes = tempStepPaletteDef.getSteps()) != null) {
                for (int i = 0; i < newMapNodes.length; ++i) {
                    newMapNodes[i].setMap(null);
                    newMapNodes[i].setLocation(null);
                    newMapNodes[i].setStepId(this.m_mapNodeIdGenerator.getNextId());
                    if (newMapNodes[i] instanceof VWStepDefinition) {
                        newMapNodes[i].setRuleSets(0, (String[])null);
                        newMapNodes[i].setRuleSets(1, (String[])null);
                        newMapNodes[i].setRuleSets(2, (String[])null);
                        ((VWStepDefinition)newMapNodes[i]).setPreMilestone(null);
                        ((VWStepDefinition)newMapNodes[i]).setPostMilestone(null);
                    } else if (newMapNodes[i] instanceof VWCompoundStepDefinition) {
                        newMapNodes[i].setRuleSets(0, (String[])null);
                        newMapNodes[i].setRuleSets(2, (String[])null);
                        VWInstructionDefinition[] instructionArray = ((VWCompoundStepDefinition)newMapNodes[i]).getInstructions();
                        if (instructionArray != null) {
                            for (int nIndex = 0; nIndex < instructionArray.length; ++nIndex) {
                                instructionArray[nIndex].setInstructionId(this.m_mapNodeIdGenerator.getNextId());
                            }
                            ((VWCompoundStepDefinition)newMapNodes[i]).setInstructions(instructionArray);
                        }
                    }
                    this.m_mapNodes = (VWMapNode[])this.m_mapNodesHandler.addElementToArray(this.m_mapNodes, newMapNodes[i]);
                }
            }
        }
        catch (Exception ex1) {
            throw new VWException("vw.api.VWWorkflowDefinitionXMLReadError", " Exception reading XML, {0}.", ex1.getMessage());
        }
        return newMapNodes;
    }

    public void deleteStep(String theStepName) throws VWException {
        if (theStepName == null) {
            throw new VWException("vw.api.VWStepPaletteDefinitionNullStepName", "The step name cannot be null.");
        }
        int nIndex = this.m_mapNodesHandler.getIndexFromStringFieldValue(this.m_mapNodes, "name", theStepName);
        if (nIndex == -1) {
            throw new VWException("vw.api.VWStepPaletteDefinitionMapNotFound", "No map node found with name equal to {0} in step palette.", theStepName);
        }
        this.m_mapNodesHandler.deleteElementFromArray(this.m_mapNodes, nIndex);
    }

    public void deleteStep(int theStepId) throws VWException {
        int nIndex = this.m_mapNodesHandler.getIndexFromIntFieldValue(this.m_mapNodes, "stepId", theStepId);
        if (nIndex == -1) {
            throw new VWException("vw.api.VWStepPaletteDefinitionMapNotFound", "No map node found with id equal to {0} in step palette.", Integer.toString(theStepId));
        }
        this.m_mapNodesHandler.deleteElementFromArray(this.m_mapNodes, nIndex);
    }

    public VWMapNode getStep(String theStepName) throws VWException {
        if (theStepName == null) {
            throw new VWException("vw.api.VWStepPaletteDefinitionNullStepName", "The step name cannot be null.");
        }
        int nIndex = this.m_mapNodesHandler.getIndexFromStringFieldValue(this.m_mapNodes, "name", theStepName);
        if (nIndex == -1) {
            throw new VWException("vw.api.VWStepPaletteDefinitionMapNotFound", "No map node found with name equal to {0} in step palette.", theStepName);
        }
        return this.m_mapNodes[nIndex];
    }

    public VWMapNode getStep(int theStepId) throws VWException {
        int nIndex = this.m_mapNodesHandler.getIndexFromIntFieldValue(this.m_mapNodes, "stepId", theStepId);
        if (nIndex == -1) {
            throw new VWException("vw.api.VWStepPaletteDefinitionMapNotFound", "No map node found with id equal to {0} in step palette.", Integer.toString(theStepId));
        }
        return this.m_mapNodes[nIndex];
    }

    public VWMapNode[] getSteps() throws VWException {
        return (VWMapNode[])this.m_mapNodesHandler.getElements(this.m_mapNodes);
    }

    public static VWStepPaletteDefinition read(InputStream theStream) throws VWException {
        if (theStream == null) {
            throw new VWException("vw.api.VWStepPaletteDefinitionNullInputStream", "InputStream parameter is null");
        }
        VWStepPaletteDefinition spd = null;
        try {
            InputStreamReader isr = new InputStreamReader(theStream, "UTF8");
            BufferedReader in = new BufferedReader(isr);
            spd = VWStepPaletteDefinition.read(in);
        }
        catch (Exception ex) {
            throw new VWException("vw.api.VWStepPaletteDefinitionXMLReadError_1", " Exception reading XML, {0}", ex.getMessage());
        }
        return spd;
    }

    public static VWStepPaletteDefinition readFromFile(String theFileName) throws VWException {
        FileInputStream istream = null;
        try {
            istream = new FileInputStream(theFileName);
            VWStepPaletteDefinition vWStepPaletteDefinition = VWStepPaletteDefinition.read(istream);
            return vWStepPaletteDefinition;
        }
        catch (Exception ex) {
            throw new VWException("vw.api.VWStepPaletteDefinitionXMLReadFromFileError", " Exception reading XML from file: {0}, {1}.", theFileName, ex.getMessage());
        }
        finally {
            if (istream != null) {
                try {
                    ((InputStream)istream).close();
                }
                catch (Exception ex2) {}
            }
        }
    }

    public void write(OutputStream theStream) throws VWException {
        if (theStream == null) {
            throw new VWException("vw.api.VWStepPaletteDefinitionNullStream", "output stream parameter is null");
        }
        StringBuffer workflowXML = new StringBuffer();
        this.toXML(workflowXML);
        try {
            OutputStreamWriter out = new OutputStreamWriter(theStream, "UTF8");
            out.write(workflowXML.toString());
            ((Writer)out).flush();
        }
        catch (Exception ex) {
            throw new VWException("vw.api.VWStepPaletteDefinitionXMLWriteError", " Exception writing XML, {0}.", ex.getMessage());
        }
    }

    public void writeToFile(String theFileName) throws VWException {
        FileOutputStream ostream = null;
        try {
            ostream = new FileOutputStream(theFileName);
            this.write(ostream);
        }
        catch (Exception ex) {
            throw new VWException("vw.api.VWStepPaletteDefinitionXMLWriteToFileError", " Exception writing XML to file, {0}.", ex.getMessage());
        }
        finally {
            if (ostream != null) {
                try {
                    ((OutputStream)ostream).close();
                }
                catch (Exception ex2) {}
            }
        }
    }

    public String toString() {
        return this.getName();
    }

    public String AsXMLString() throws VWException {
        StringBuffer workflowXML = new StringBuffer();
        this.toXML(workflowXML);
        return workflowXML.toString();
    }

    public void toXML(StringBuffer theBuffer) throws VWException {
        String ATTRIB_INDENT = "\t";
        if (theBuffer == null) {
            throw new VWException("vw.api.VWStepPaletteDefinitionNullBuffer", "buffer parameter cannot be null.");
        }
        theBuffer.append("<?xml version='1.0' encoding='UTF-8'?>\n<!DOCTYPE StepPaletteDefinition SYSTEM \"spdef4.dtd\">\n<StepPaletteDefinition ApiVersion=\"4.0\"\nOrigin=\"JavaAPI\"\n");
        if (this.m_name != null) {
            theBuffer.append(ATTRIB_INDENT + "Name=\"" + VWXMLHandler.toXMLString(this.getName()) + "\"");
        }
        if (this.m_description != null) {
            theBuffer.append("\n" + ATTRIB_INDENT + "Description=\"" + VWXMLHandler.toXMLString(this.getDescription()) + "\"");
        }
        theBuffer.append("\n" + ATTRIB_INDENT + "MaxStepId=\"" + Integer.toString(this.m_mapNodeIdGenerator.getPrevId()) + "\"");
        theBuffer.append(">\n");
        VWMapNode[] steps = this.getSteps();
        if (steps != null) {
            for (int i = 0; i < steps.length; ++i) {
                this.m_mapNodes[i].toXML(theBuffer);
            }
        }
        theBuffer.append("</StepPaletteDefinition>\n");
    }

    protected VWStepDefinition createEmptyStep() throws VWException {
        VWStepDefinition newStep = new VWStepDefinition(this);
        this.m_mapNodes = (VWMapNode[])this.m_mapNodesHandler.addElementToArray(this.m_mapNodes, newStep);
        return newStep;
    }

    protected VWCompoundStepDefinition createEmptyCompoundStep() throws VWException {
        VWCompoundStepDefinition newStep = new VWCompoundStepDefinition(this);
        this.m_mapNodes = (VWMapNode[])this.m_mapNodesHandler.addElementToArray(this.m_mapNodes, newStep);
        return newStep;
    }

    protected void updateNextStepId() throws VWException {
        this.m_mapNodeIdGenerator.setNextId(this.findHighestStepId() + 1);
    }

    protected int findHighestStepId() throws VWException {
        int currentHighestStepId = 1;
        int numSteps = this.m_mapNodesHandler.getElementCount();
        for (int i = 0; i < numSteps; ++i) {
            VWInstructionDefinition[] instArray;
            if (this.m_mapNodes[i].getStepId() > currentHighestStepId) {
                currentHighestStepId = this.m_mapNodes[i].getStepId();
            }
            if (!(this.m_mapNodes[i] instanceof VWCompoundStepDefinition) || (instArray = ((VWCompoundStepDefinition)this.m_mapNodes[i]).getInstructions()) == null) continue;
            for (int j = 0; j < instArray.length; ++j) {
                if (instArray[j].getInstructionId() <= currentHighestStepId) continue;
                currentHighestStepId = instArray[j].getInstructionId();
            }
        }
        return currentHighestStepId;
    }

    protected VWIdGenerator getStepIdGenerator() {
        return this.m_mapNodeIdGenerator;
    }

    private static VWStepPaletteDefinition read(BufferedReader in) throws VWException {
        VWStepPaletteDefinition spd = null;
        try {
            spd = VWXMLHandler.parseXMLStepPalette(in, true);
            if (spd == null) {
                throw new VWException("vw.api.VWStepPaletteDefinitionXMLReadParseError", "XML Parsing error.");
            }
        }
        catch (SAXParseException err) {
            VWString parsingError = new VWString("vw.api.ParsingError", "** Parsing error");
            VWString line = new VWString("vw.api.Line", "line");
            String errString = parsingError + ", " + line + " " + err.getLineNumber() + ", uri " + err.getSystemId() + "\n" + "   " + err.getMessage();
            throw new VWException("vw.api.VWStepPaletteDefinitionXMLReadParse", "XML Parsing error {0}.", errString);
        }
        catch (Exception ex) {
            throw new VWException(ex);
        }
        return spd;
    }
}

